##########################
### Exploring Binary Data
##########################

## Budworm Example - scatterplots of binomial data
ldose <- rep(0:5, 2)
dead <- c(1, 4, 9, 13, 18, 20, 0, 2, 6, 10, 12, 16)
sex <- factor(rep(c("M", "F"), c(6, 6)))

plot(c(1, 32), c(0, 1), type = "n", xlab = "dose",
     ylab = "prob", log = "x")
text(2^ldose, dead/20, labels = sex)

emp.logits <- log((dead + 0.5)/(20.5 - dead))
plot(c(1, 32), range(emp.logits), type = "n", xlab = "dose",
     ylab = "emp.logit", log = "x")
text(2^ldose, emp.logits, labels = sex)

y <- cbind(dead, 20 - dead)
sing <- glm(y ~ ldose, family = binomial) ## the logit link is the default for the binomial 
                                          ## family so doesn't need to be specified
summary(sing)

## nested models

parr <- glm(y ~ ldose + sex, family = binomial)
summary(parr)
anova(sing, parr, test = "Chisq")

sep <- glm(y ~ sex*ldose, family = binomial)
anova(sep, test = "Chisq")

## confidence intervals

confint.lm(parr)
                  
## predict

plot(c(1, 32), range(emp.logits), type = "n", xlab = "dose",
     ylab = "emp.logit", log = "x")
text(2^ldose, emp.logits, labels = sex)
lines(2^ldose[sex == "M"],
      predict(parr, type = "link")[sex == "M"], col = 3)
lines(2^ldose[sex == "M"],
      predict(parr, type = "link")[sex == "F"], col = 2)

plot(c(1, 32), c(0, 1), type = "n", xlab = "dose",
     ylab = "prob", log = "x")
text(2^ldose, dead/20, labels = sex)
ld <- seq(0, 5, 0.1) ## generating new data over smaller intervals to obtain a smoother curve
newdat <- data.frame(ldose = c(ld, ld),
                     sex = gl(2, length(ld),
                     labels = c("F", "M")))
lines(2^ld, predict(parr, type = "response",
                    newdat = subset(newdat, sex == "M")),
      col = 3)
lines(2^ld, predict(parr, type = "response",
                    newdat = subset(newdat, sex == "F")),
      col = 2)


